# Copyright 1999-2007 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: $

inherit eutils

ECVS_SERVER="cvs.ogre3d.org:/cvsroot/ogre"
ECVS_MODULE="ogreaddons/ogrenewt"
ECVS_AUTH="pserver"
ECVS_USER="anonymous"

inherit cvs

DESCRIPTION="ogrenewt addon to ogre"
HOMEPAGE="http://www.ogre3d.org/"

LICENSE="LGPL-2.1"
SLOT="0"
KEYWORDS="~x86"
IUSE=""

RDEPEND="=dev-games/newton-1.53_p99
        >=dev-games/ogre-1.4.7_p99
        >=dev-libs/boost-1.34.1_p99"
DEPEND="${RDEPEND}
        >=dev-util/scons-0.97"

# no version number in source path:
#S=${WORKDIR}/${PN}
S=${WORKDIR}/${ECVS_MODULE}

src_compile() {
	einfo "patching ogrenewt to remove BasicFramListener and old boost"
	cd "${S}"
	epatch "${FILESDIR}"/ogrenewt.patch || die "failed to patch"
	rm -r ./OgreNewt_Main/inc/boost || die "failed to remove stale boost"

	cp SConscript ./OgreNewt_Main/ || die "failed to copy SConscript"

	# this should be possible without the hardcoded lib-path:
	cp /usr/lib/libNewton.a . || die "failed to make a copy of newton library"
}

src_install() {
	# I am not sure if there is an easy way to separate build and
	# install for this SConstruct file

	#scons boost=$PREFIX/include/boost-1_34 install
	scons install prefix="${D}/usr" || die "scons install failed"
}
