/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.script.rhino;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import org.apache.batik.bridge.InterruptedBridgeException;
import org.apache.batik.script.Interpreter;
import org.apache.batik.script.InterpreterException;
import org.apache.batik.script.Window;
import org.apache.batik.script.rhino.BatikSecurityController;
import org.apache.batik.script.rhino.BatikWrapFactory;
import org.apache.batik.script.rhino.EventTargetWrapper;
import org.apache.batik.script.rhino.RhinoClassLoader;
import org.apache.batik.script.rhino.RhinoClassShutter;
import org.apache.batik.script.rhino.WindowWrapper;
import org.mozilla.javascript.ClassShutter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeJavaPackage;
import org.mozilla.javascript.PropertyException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SecurityController;
import org.mozilla.javascript.WrapFactory;
import org.mozilla.javascript.WrappedException;
import org.w3c.dom.events.EventTarget;

public class RhinoInterpreter
implements Interpreter {
    private static String[] TO_BE_IMPORTED = new String[]{"java.lang", "org.w3c.dom", "org.w3c.dom.css", "org.w3c.dom.events", "org.w3c.dom.smil", "org.w3c.dom.stylesheets", "org.w3c.dom.svg", "org.w3c.dom.views"};
    protected Window window;
    private static final int MAX_CACHED_SCRIPTS = 32;
    public static final String SOURCE_NAME_SVG = "<SVG>";
    public static final String BIND_NAME_WINDOW = "window";
    private ScriptableObject globalObject = null;
    private LinkedList compiledScripts = new LinkedList();
    private WrapFactory wrapFactory = new BatikWrapFactory(this);
    protected RhinoClassLoader rhinoClassLoader;
    private SecurityController securityController = new BatikSecurityController();
    Map objects = new HashMap(4);
    static Method rhinoGetter;
    static /* synthetic */ Class class$org$apache$batik$script$rhino$WindowWrapper;
    static /* synthetic */ Class class$org$mozilla$javascript$ScriptableObject;
    static /* synthetic */ Class class$org$apache$batik$script$rhino$RhinoInterpreter$RhinoGetDelegate;

    public Window getWindow() {
        return this.window;
    }

    public RhinoInterpreter(URL uRL) {
        try {
            this.rhinoClassLoader = new RhinoClassLoader(uRL, this.getClass().getClassLoader());
        }
        catch (SecurityException securityException) {
            this.rhinoClassLoader = null;
        }
        Context context = this.enterContext();
        try {
            Object object;
            try {
                object = context.initStandardObjects(null, false);
                ScriptableObject.defineClass((Scriptable)object, (Class)(class$org$apache$batik$script$rhino$WindowWrapper == null ? (class$org$apache$batik$script$rhino$WindowWrapper = RhinoInterpreter.class$("org.apache.batik.script.rhino.WindowWrapper")) : class$org$apache$batik$script$rhino$WindowWrapper));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.globalObject = object = new WindowWrapper(context);
            Object[] objectArray = new NativeJavaPackage[TO_BE_IMPORTED.length];
            int n = 0;
            while (n < TO_BE_IMPORTED.length) {
                objectArray[n] = new NativeJavaPackage(TO_BE_IMPORTED[n], (ClassLoader)this.rhinoClassLoader);
                ++n;
            }
            try {
                ScriptableObject.callMethod((Scriptable)this.globalObject, (String)"importPackage", (Object[])objectArray);
            }
            catch (JavaScriptException javaScriptException) {
            }
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
    }

    public AccessControlContext getAccessControlContext() {
        return this.rhinoClassLoader.getAccessControlContext();
    }

    public Context enterContext() {
        Context context = Context.getCurrentContext();
        if (context == null) {
            context = new ExtendedContext();
            context.setWrapFactory(this.wrapFactory);
            context.setSecurityController(this.securityController);
            context.setClassShutter((ClassShutter)new RhinoClassShutter());
        }
        context = Context.enter((Context)context);
        return context;
    }

    protected ScriptableObject getGlobalObject() {
        return this.globalObject;
    }

    public Object evaluate(Reader reader) throws InterpreterException, IOException {
        return this.evaluate(reader, SOURCE_NAME_SVG);
    }

    public Object evaluate(Reader reader, String string) throws InterpreterException, IOException {
        Object object = null;
        Context context = this.enterContext();
        try {
            try {
                object = context.evaluateReader((Scriptable)this.globalObject, reader, string, 1, (Object)this.rhinoClassLoader);
            }
            catch (JavaScriptException javaScriptException) {
                if (javaScriptException.getValue() instanceof Exception) {
                    Exception exception = (Exception)javaScriptException.getValue();
                    throw new InterpreterException(exception, exception.getMessage(), -1, -1);
                }
                throw new InterpreterException((Exception)((Object)javaScriptException), javaScriptException.getMessage(), -1, -1);
            }
            catch (WrappedException wrappedException) {
                Throwable throwable = wrappedException.getWrappedException();
                if (throwable instanceof Exception) {
                    throw new InterpreterException((Exception)wrappedException.getWrappedException(), wrappedException.getWrappedException().getMessage(), -1, -1);
                }
                throw new InterpreterException(wrappedException.getWrappedException().getMessage(), -1, -1);
            }
            catch (InterruptedBridgeException interruptedBridgeException) {
                throw interruptedBridgeException;
            }
            catch (RuntimeException runtimeException) {
                throw new InterpreterException(runtimeException, runtimeException.getMessage(), -1, -1);
            }
            Object var10_5 = null;
        }
        catch (Throwable throwable) {
            Object var10_6 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
        return object;
    }

    public Object evaluate(final String string) throws InterpreterException {
        Object object = null;
        final Context context = this.enterContext();
        try {
            Script script = null;
            Entry entry = null;
            Iterator iterator = this.compiledScripts.iterator();
            while (iterator.hasNext()) {
                entry = (Entry)iterator.next();
                if (!entry.str.equals(string)) continue;
                script = entry.script;
                iterator.remove();
                break;
            }
            if (script == null) {
                script = (Script)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            return context.compileReader((Scriptable)RhinoInterpreter.this.globalObject, (Reader)new StringReader(string), RhinoInterpreter.SOURCE_NAME_SVG, 1, (Object)RhinoInterpreter.this.rhinoClassLoader);
                        }
                        catch (IOException iOException) {
                            throw new Error();
                        }
                    }
                });
                if (this.compiledScripts.size() + 1 > 32) {
                    this.compiledScripts.removeFirst();
                }
                this.compiledScripts.addLast(new Entry(string, script));
            } else {
                this.compiledScripts.addLast(entry);
            }
            try {
                object = script.exec(context, (Scriptable)this.globalObject);
            }
            catch (JavaScriptException javaScriptException) {
                if (javaScriptException.getValue() instanceof Exception) {
                    Exception exception = (Exception)javaScriptException.getValue();
                    throw new InterpreterException(exception, exception.getMessage(), -1, -1);
                }
                throw new InterpreterException((Exception)((Object)javaScriptException), javaScriptException.getMessage(), -1, -1);
            }
            catch (WrappedException wrappedException) {
                throw new InterpreterException((Exception)wrappedException.getWrappedException(), wrappedException.getWrappedException().getMessage(), -1, -1);
            }
            catch (RuntimeException runtimeException) {
                throw new InterpreterException(runtimeException, runtimeException.getMessage(), -1, -1);
            }
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
        return object;
    }

    public void dispose() {
        Context.setCachingEnabled((boolean)false);
        Context.setCachingEnabled((boolean)true);
    }

    public void bindObject(String string, Object object) {
        this.enterContext();
        try {
            if (string.equals(BIND_NAME_WINDOW) && object instanceof Window) {
                this.window = (Window)object;
                object = this.globalObject;
            }
            try {
                Scriptable scriptable = Context.toObject((Object)object, (Scriptable)this.globalObject);
                this.objects.put(string, scriptable);
                if (ScriptableObject.getProperty((Scriptable)this.globalObject, (String)string) == Scriptable.NOT_FOUND) {
                    this.globalObject.defineProperty(string, (Object)new RhinoGetDelegate(string), rhinoGetter, null, 1);
                }
            }
            catch (PropertyException propertyException) {
                propertyException.printStackTrace();
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
    }

    void callHandler(Function function, Object object) throws JavaScriptException {
        Context context = this.enterContext();
        try {
            object = Context.toObject((Object)object, (Scriptable)this.globalObject);
            Object[] objectArray = new Object[]{object};
            function.call(context, (Scriptable)this.globalObject, (Scriptable)this.globalObject, objectArray);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
    }

    void callMethod(ScriptableObject scriptableObject, String string, ArgumentsBuilder argumentsBuilder) throws JavaScriptException {
        this.enterContext();
        try {
            ScriptableObject.callMethod((Scriptable)scriptableObject, (String)string, (Object[])argumentsBuilder.buildArguments());
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
    }

    void callHandler(Function function, Object[] objectArray) throws JavaScriptException {
        Context context = this.enterContext();
        try {
            function.call(context, (Scriptable)this.globalObject, (Scriptable)this.globalObject, objectArray);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
    }

    void callHandler(Function function, ArgumentsBuilder argumentsBuilder) throws JavaScriptException {
        Context context = this.enterContext();
        try {
            Object[] objectArray = argumentsBuilder.buildArguments();
            function.call(context, function.getParentScope(), (Scriptable)this.globalObject, objectArray);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
    }

    Scriptable buildEventTargetWrapper(EventTarget eventTarget) {
        return new EventTargetWrapper((Scriptable)this.globalObject, eventTarget);
    }

    public void setOut(Writer writer) {
    }

    public Locale getLocale() {
        return null;
    }

    public void setLocale(Locale locale) {
    }

    public String formatMessage(String string, Object[] objectArray) {
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            Class[] classArray = new Class[]{class$org$mozilla$javascript$ScriptableObject == null ? (class$org$mozilla$javascript$ScriptableObject = RhinoInterpreter.class$("org.mozilla.javascript.ScriptableObject")) : class$org$mozilla$javascript$ScriptableObject};
            rhinoGetter = (class$org$apache$batik$script$rhino$RhinoInterpreter$RhinoGetDelegate == null ? (class$org$apache$batik$script$rhino$RhinoInterpreter$RhinoGetDelegate = RhinoInterpreter.class$("org.apache.batik.script.rhino.RhinoInterpreter$RhinoGetDelegate")) : class$org$apache$batik$script$rhino$RhinoInterpreter$RhinoGetDelegate).getDeclaredMethod("get", classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public class ExtendedContext
    extends Context {
        public RhinoInterpreter getInterpreter() {
            return RhinoInterpreter.this;
        }

        public Window getWindow() {
            return RhinoInterpreter.this.getWindow();
        }

        public ScriptableObject getGlobalObject() {
            return RhinoInterpreter.this.getGlobalObject();
        }
    }

    public static interface ArgumentsBuilder {
        public Object[] buildArguments();
    }

    public static class RhinoGetDelegate {
        String name;

        RhinoGetDelegate(String string) {
            this.name = string;
        }

        public Object get(ScriptableObject scriptableObject) {
            Context context = Context.getCurrentContext();
            if (context == null) {
                return null;
            }
            return ((ExtendedContext)context).getInterpreter().objects.get(this.name);
        }
    }

    private static class Entry {
        String str;
        Script script;

        Entry(String string, Script script) {
            this.str = string;
            this.script = script;
        }
    }
}

