/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.image;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.codec.ImageEncodeParam;
import org.apache.batik.ext.awt.image.codec.tiff.TIFFEncodeParam;
import org.apache.batik.ext.awt.image.codec.tiff.TIFFField;
import org.apache.batik.ext.awt.image.codec.tiff.TIFFImageEncoder;
import org.apache.batik.ext.awt.image.rendered.FormatRed;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.image.resources.Messages;

public class TIFFTranscoder
extends ImageTranscoder {
    public static final TranscodingHints.Key KEY_FORCE_TRANSPARENT_WHITE = ImageTranscoder.KEY_FORCE_TRANSPARENT_WHITE;

    public TIFFTranscoder() {
        this.hints.put(KEY_FORCE_TRANSPARENT_WHITE, Boolean.FALSE);
    }

    public BufferedImage createImage(int n, int n2) {
        return new BufferedImage(n, n2, 2);
    }

    public void writeImage(BufferedImage bufferedImage, TranscoderOutput transcoderOutput) throws TranscoderException {
        int n;
        DataBufferInt dataBufferInt;
        OutputStream outputStream = transcoderOutput.getOutputStream();
        if (outputStream == null) {
            throw new TranscoderException(Messages.formatMessage("tiff.badoutput", null));
        }
        TIFFEncodeParam tIFFEncodeParam = new TIFFEncodeParam();
        float f = this.userAgent.getPixelUnitToMillimeter();
        int n2 = (int)((double)(100000.0f / f) + 0.5);
        int n3 = 10000;
        long[] lArray = new long[]{n2, n3};
        TIFFField[] tIFFFieldArray = new TIFFField[]{new TIFFField(296, 3, 1, (Object)new char[]{'\u0003'}), new TIFFField(282, 5, 1, (Object)new long[][]{lArray}), new TIFFField(283, 5, 1, (Object)new long[][]{lArray})};
        tIFFEncodeParam.setExtraFields(tIFFFieldArray);
        boolean bl = false;
        if (this.hints.containsKey(KEY_FORCE_TRANSPARENT_WHITE)) {
            bl = (Boolean)this.hints.get(KEY_FORCE_TRANSPARENT_WHITE);
        }
        int n4 = bufferedImage.getWidth();
        int n5 = bufferedImage.getHeight();
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)bufferedImage.getSampleModel();
        if (bl) {
            dataBufferInt = (DataBufferInt)bufferedImage.getRaster().getDataBuffer();
            n = singlePixelPackedSampleModel.getScanlineStride();
            int n6 = dataBufferInt.getOffset();
            int[] nArray = dataBufferInt.getBankData()[0];
            int n7 = n6;
            int n8 = n - n4;
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            int n12 = 0;
            int n13 = 0;
            int n14 = 0;
            while (n14 < n5) {
                int n15 = 0;
                while (n15 < n4) {
                    n13 = nArray[n7];
                    n9 = n13 >> 24 & 0xFF;
                    n10 = n13 >> 16 & 0xFF;
                    n11 = n13 >> 8 & 0xFF;
                    n12 = n13 & 0xFF;
                    n10 = (255 * (255 - n9) + n9 * n10) / 255;
                    n11 = (255 * (255 - n9) + n9 * n11) / 255;
                    n12 = (255 * (255 - n9) + n9 * n12) / 255;
                    nArray[n7++] = n9 << 24 & 0xFF000000 | n10 << 16 & 0xFF0000 | n11 << 8 & 0xFF00 | n12 & 0xFF;
                    ++n15;
                }
                n7 += n8;
                ++n14;
            }
        }
        try {
            dataBufferInt = new TIFFImageEncoder(outputStream, (ImageEncodeParam)tIFFEncodeParam);
            n = singlePixelPackedSampleModel.getNumBands();
            int[] nArray = new int[n];
            int n16 = 0;
            while (n16 < n) {
                nArray[n16] = n16;
                ++n16;
            }
            PixelInterleavedSampleModel pixelInterleavedSampleModel = new PixelInterleavedSampleModel(0, n4, n5, n, n4 * n, nArray);
            FormatRed formatRed = new FormatRed(GraphicsUtil.wrap((RenderedImage)bufferedImage), (SampleModel)pixelInterleavedSampleModel);
            dataBufferInt.encode((RenderedImage)formatRed);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new TranscoderException(iOException);
        }
    }
}

