/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.plaf;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.AttributedCharacterIterator;
import java.text.DateFormat;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.text.InternationalFormatter;

public final class ExtBasicArrowButtonHandler
extends AbstractAction
implements MouseListener {
    private final Timer autoRepeatTimer;
    private final boolean isNext;
    private JSpinner spinner = null;

    public ExtBasicArrowButtonHandler(String name, boolean isNext) {
        super(name);
        this.isNext = isNext;
        this.autoRepeatTimer = new Timer(60, this);
        this.autoRepeatTimer.setInitialDelay(300);
    }

    private JSpinner eventToSpinner(AWTEvent e2) {
        Object src = e2.getSource();
        while (src instanceof Component && !(src instanceof JSpinner)) {
            src = ((Component)src).getParent();
        }
        return src instanceof JSpinner ? (JSpinner)src : null;
    }

    public void actionPerformed(ActionEvent e2) {
        JSpinner spinner = this.spinner;
        if (!(e2.getSource() instanceof Timer)) {
            spinner = this.eventToSpinner(e2);
        }
        if (spinner != null) {
            try {
                Object value;
                int calendarField = this.getCalendarField(spinner);
                spinner.commitEdit();
                if (calendarField != -1) {
                    ((SpinnerDateModel)spinner.getModel()).setCalendarField(calendarField);
                }
                Object object = value = this.isNext ? spinner.getNextValue() : spinner.getPreviousValue();
                if (value != null) {
                    spinner.setValue(value);
                    this.select(spinner);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                UIManager.getLookAndFeel().provideErrorFeedback(spinner);
            }
            catch (ParseException parseException) {
                UIManager.getLookAndFeel().provideErrorFeedback(spinner);
            }
        }
    }

    private void select(JSpinner spinner) {
        JComponent editor = spinner.getEditor();
        if (editor instanceof JSpinner.DateEditor) {
            SpinnerDateModel model;
            DateFormat.Field field;
            Object value;
            JSpinner.DateEditor dateEditor = (JSpinner.DateEditor)editor;
            JFormattedTextField ftf = dateEditor.getTextField();
            SimpleDateFormat format = dateEditor.getFormat();
            if (format != null && (value = spinner.getValue()) != null && (field = DateFormat.Field.ofCalendarField((model = dateEditor.getModel()).getCalendarField())) != null) {
                try {
                    AttributedCharacterIterator iterator = ((Format)format).formatToCharacterIterator(value);
                    if (!this.select(ftf, iterator, field) && field == DateFormat.Field.HOUR0) {
                        this.select(ftf, iterator, DateFormat.Field.HOUR1);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
    }

    private boolean select(JFormattedTextField ftf, AttributedCharacterIterator iterator, DateFormat.Field field) {
        int max = ftf.getDocument().getLength();
        iterator.first();
        do {
            Map<AttributedCharacterIterator.Attribute, Object> attrs;
            if ((attrs = iterator.getAttributes()) == null || !attrs.containsKey(field)) continue;
            int start = iterator.getRunStart(field);
            int end = iterator.getRunLimit(field);
            if (start != -1 && end != -1 && start <= max && end <= max) {
                ftf.select(start, end);
            }
            return true;
        } while (iterator.next() != '\uffff');
        return false;
    }

    private int getCalendarField(JSpinner spinner) {
        JComponent editor = spinner.getEditor();
        if (editor instanceof JSpinner.DateEditor) {
            JSpinner.DateEditor dateEditor = (JSpinner.DateEditor)editor;
            JFormattedTextField ftf = dateEditor.getTextField();
            int start = ftf.getSelectionStart();
            JFormattedTextField.AbstractFormatter formatter = ftf.getFormatter();
            if (formatter instanceof InternationalFormatter) {
                Format.Field[] fields = ((InternationalFormatter)formatter).getFields(start);
                int counter = 0;
                while (counter < fields.length) {
                    int calendarField;
                    if (fields[counter] instanceof DateFormat.Field && (calendarField = fields[counter] == DateFormat.Field.HOUR1 ? 10 : ((DateFormat.Field)fields[counter]).getCalendarField()) != -1) {
                        return calendarField;
                    }
                    ++counter;
                }
            }
        }
        return -1;
    }

    public void mousePressed(MouseEvent e2) {
        if (SwingUtilities.isLeftMouseButton(e2) && e2.getComponent().isEnabled()) {
            this.spinner = this.eventToSpinner(e2);
            this.autoRepeatTimer.start();
            this.focusSpinnerIfNecessary();
        }
    }

    public void mouseReleased(MouseEvent e2) {
        this.autoRepeatTimer.stop();
        this.spinner = null;
    }

    public void mouseClicked(MouseEvent e2) {
    }

    public void mouseEntered(MouseEvent e2) {
    }

    public void mouseExited(MouseEvent e2) {
    }

    private void focusSpinnerIfNecessary() {
        Component fo = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (this.spinner.isRequestFocusEnabled() && (fo == null || !SwingUtilities.isDescendingFrom(fo, this.spinner))) {
            FocusTraversalPolicy ftp;
            Component child;
            Container root = this.spinner;
            if (!root.isFocusCycleRoot()) {
                root = root.getFocusCycleRootAncestor();
            }
            if (root != null && (child = (ftp = root.getFocusTraversalPolicy()).getComponentAfter(root, this.spinner)) != null && SwingUtilities.isDescendingFrom(child, this.spinner)) {
                child.requestFocus();
            }
        }
    }
}

